using System;
using Server;
using Server.Mobiles;
using Server.Gumps;
using Server.Network;

namespace Server.Items
{
	[FlipableAttribute( 0x13B6, 0x13B5 )]
   public class SpectralScimitarOfEvolution : BaseGoldEater
	{
		public override int GumpButton1 { get { return 30038; } }
		public override int GumpButton2 { get { return 30049; } }
		public override string RawWeaponName { get { return "Spectral Scimitar of Evolution"; } }
		
		public override SkillName DefSkill{ get{ return SkillName.Swords; } }
		public override WeaponType DefType{ get{ return WeaponType.Slashing; } }
		public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.Slash1H; } }
		
		public override int AosMinDamage{ get{ return 13; } }
		public override int AosMaxDamage{ get{ return 17; } }
		public override int AosSpeed{ get{ return 40; } }
		
		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.DoubleStrike; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.ParalyzingBlow; } }

		public override int AosStrengthReq{ get{ return 100; } }

		public override int OldStrengthReq{ get{ return 10; } }
		public override int OldMinDamage{ get{ return 4; } }
		public override int OldMaxDamage{ get{ return 30; } }
		public override int OldSpeed{ get{ return 43; } }

		public override int DefHitSound{ get{ return 0x23B; } }
		public override int DefMissSound{ get{ return 0x23A; } }

		[Constructable]
		public SpectralScimitarOfEvolution() : base( 0x13B6 )
		{
			Name = RawWeaponName;
			Hue = 2633;
			Weight = 5.0;

			Attributes.Luck = 75;
			Slayer = SlayerName.Exorcism;
		}
		
		public override void GetDamageTypes( Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy )
		{
			fire = cold = pois = 0;
			phys = 25;
			nrgy = 75;
		}
		
		public override void DoSpecial1( BaseGoldEater weap, Mobile from )
      {
         if ( !from.Backpack.ConsumeTotal( typeof( Gold ), 100 ) )
            from.SendMessage( "Nemas u sebe 100 zlatych pro provedeni teto akce!" );
         else
         {
            from.AddSkillMod( new TimedSkillMod( SkillName.Anatomy, true, 20, TimeSpan.FromSeconds(20.0) ) );
				from.AddStatMod( new StatMod( StatType.All, "EvoWeaponBuff", 30, TimeSpan.FromSeconds(20.0) ) );
			   from.FixedParticles( 0x376A, 1, 20, 0x7F5, weap.Hue, 0x3, EffectLayer.Waist );
			   from.PlaySound( 0x50D );
			   from.PlaySound( 0x51B );
            weap.NextSpecial = DateTime.Now + TimeSpan.FromSeconds( 40.0 );
         }
      }
      
		public override void DoSpecial2( BaseGoldEater weap, Mobile from )
      {
			if ( from.Followers + 1 > from.FollowersMax )
			{
				from.SendLocalizedMessage( 1074270 ); // You have too many followers to summon another one.				
			}
			else
			{
            if ( !from.Backpack.ConsumeTotal( typeof( Gold ), 500 ) )
               from.SendMessage( "Nemas u sebe 500 zlatych pro provedeni teto akce!" );
            else
            {
					BaseCreature mob = new SpectralScimitar();
               BaseCreature.Summon( mob, from, from.Location, mob.BaseSoundID, TimeSpan.FromSeconds( 30 ) );
					Effects.SendLocationParticles( EffectItem.Create( mob.Location, mob.Map, EffectItem.DefaultDuration ), 0x3728, 1, 10, 0x26B6 );
					mob.Summoned = false;
					mob.Hue = weap.Hue;
					mob.ControlOrder = OrderType.Guard;
					
               weap.NextSpecial2 = DateTime.Now + TimeSpan.FromSeconds( 320 - Math.Max( 1, weap.WeaponAttributes.HitHarm * 2 ) );
            }
         }
      }

		public SpectralScimitarOfEvolution(Serial serial) : base(serial)
		{
		}
		
		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}
